/*
 * statsvisits.cpp
 *
 *  Created on: 19.3.2010
 *      Author: aahv
 */

#include "statsvisits.h"
#include "ui_statsvisits.h"

#include <QList>
#include <QPair>
#include <QDate>
#include <QMap>
#include <QPushButton>

StatsVisits::StatsVisits(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::StatsVisits)
{
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->layoutWidget);

    plot = new LinePlot(this);
    plot->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    dailyData = new StatsDailyData();
    weeklyData = new StatsWeeklyData();
    monthlyData = new StatsMonthlyData();

    ui->dayButton->setChecked(true);
    ui->layout->addWidget(plot);

    connect(ui->viewButtonGroup, SIGNAL(buttonClicked(QAbstractButton*)), this, SLOT(buttonClicked(QAbstractButton*)));
}

StatsVisits::~StatsVisits()
{
    delete ui;
    delete dailyData;
    delete weeklyData;
    delete monthlyData;
}

void StatsVisits::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void StatsVisits::buttonClicked(QAbstractButton *button) {
    if (button == ui->dayButton) {
        switchPlotData(dailyData);
    } else if (button == ui->weekButton) {
        switchPlotData(weeklyData);
    } else if (button == ui->monthButton) {
        switchPlotData(monthlyData);
    }
}

void StatsVisits::updateStats(const WPDataStats &stats) {
    ui->label->setText(tr("Visits (%1 total visits in last 365 days)").arg(stats.iTotalVisits));

    dailyData->reload(stats.iVisits);
    weeklyData->reload(stats.iVisits);
    monthlyData->reload(stats.iVisits);

    switchPlotData(dailyData);
}

void StatsVisits::switchPlotData(LinePlotData *data) {
    if (data->getDataCount() == 0)
        return;

    plot->setData(data);
    plot->setXAxisMajorTickFrequency((data == dailyData? 2: 1));
    plot->repaint();
}
