/*
 * statsmonthlydata.h
 *
 *  Created on: 22.3.2010
 *      Author: aahv
 */

#ifndef STATSMONTHLYDATA_H
#define STATSMONTHLYDATA_H

#include "lineplotdata.h"

#include <QMap>
#include <QDate>

class StatsMonthlyData : public LinePlotData
{
public:
    StatsMonthlyData();
    ~StatsMonthlyData();

    int getDataCount() const;

    int getMinValue() const;
    int getMaxValue() const;
    int getValue(int index) const;

    QVariant getData(int index) const;

    void reload(const QMap<QDate, int>& data, QDate from = QDate::currentDate().addYears(-1), QDate to = QDate::currentDate());
private:
    QMap<QDate, int> data;

    int maxValue;
    int minValue;

};

#endif // STATSMONTHLYDATA_H
