/*
 * statsmonthlydata.cpp
 *
 *  Created on: 22.3.2010
 *      Author: aahv
 */

#include "statsmonthlydata.h"

StatsMonthlyData::StatsMonthlyData() : LinePlotData()
{

}

StatsMonthlyData::~StatsMonthlyData() {

}

void StatsMonthlyData::reload(const QMap<QDate, int> &data, QDate from, QDate to) {
    this->data.clear();

    minValue = 0;
    maxValue = 0;

    from = QDate(from.year(), from.month(), 1);
    to = QDate(to.year(), to.month(), 1);

    QMap<QDate, int>::const_iterator it = data.lowerBound(from);
    QMap<QDate, int>::const_iterator itEnd = data.upperBound(to.addMonths(1));

    int count = 0;
    while (from <= to && it != itEnd) {
        QDate key = QDate(it.key().year(), it.key().month(), 1);
        if (key == from) {
            count += it.value();
            it++;
        } else {
            this->data.insert(from, count);

            if (count < minValue)
                minValue = count;
            if (count > maxValue)
                maxValue = count;

            count = 0;
            from = from.addMonths(1);
        }
    }

    this->data.insert(to, count);

    if (count < minValue)
        minValue = count;
    if (count > maxValue)
        maxValue = count;
}

int StatsMonthlyData::getDataCount() const {
    return data.size();
}

QVariant StatsMonthlyData::getData(int index) const {
    return data.keys()[index].toString("yyyy-MM");
}

int StatsMonthlyData::getMinValue() const {
    return minValue;
}

int StatsMonthlyData::getMaxValue() const {
    return maxValue;
}

int StatsMonthlyData::getValue(int index) const {
    return data.values()[index];
}
