/*
 * statsdailydata.cpp
 *
 *  Created on: 22.3.2010
 *      Author: aahv
 */

#include "statsdailydata.h"

#include <limits.h>

StatsDailyData::StatsDailyData() : LinePlotData()
{

}

StatsDailyData::~StatsDailyData() {

}

void StatsDailyData::reload(const QMap<QDate, int> &data, QDate from, QDate to) {
    this->data.clear();

    minValue = INT_MAX;
    maxValue = INT_MIN;

    while (from <= to) {
        int value = data[from];
        if (value < minValue)
            minValue = value;
        if (value > maxValue)
            maxValue = value;

        this->data.insert(from, value);

        from = from.addDays(1);
    }
}

int StatsDailyData::getDataCount() const {
    return data.size();
}

QVariant StatsDailyData::getData(int index) const {
    return data.keys()[index].toString("MM-dd");
}

int StatsDailyData::getMinValue() const {
    return minValue;
}

int StatsDailyData::getMaxValue() const {
    return maxValue;
}

int StatsDailyData::getValue(int index) const {
    return data.values()[index];
}


