/*
 * setupblog.cpp
 *
 *  Created on: ?
 *      Author: ?
 */

#include <QAction>
#include <QList>
#include <QMenu>
#include <QPushButton>
#include <QDesktopWidget> 
#include <QMessageBox>
#include <QKeyEvent>

#include "setupblog.h"
#include "BlogView.h"
#include "wpconfirmdialog.h"

SetupBlog::SetupBlog(BlogView *aBlogView, QWidget *parent)
  : QFrame(parent)
  , iBlogView(aBlogView)
  , iEditedBlog(0)
{
    ui.setupUi(this);
    ui.scrollArea->setWidget(ui.layoutWidget);
    ui.layoutWidget->setContentsMargins(5, 5, 5, 5);

    iEditingBlog = false;
    iCancelSet = false;

    iSvg = new QSvgWidget(":/images/wp-logo.svg", this);
    iSvg->setFixedSize(200, 200);

    //ui.horizontalLayout->addStretch();
    ui.horizontalLayout->addWidget(iSvg);
    ui.horizontalLayout->setStretchFactor(iSvg,1);
    //ui.horizontalLayout->addStretch();
    
    setTabOrder(iSvg,ui.blogStartLabel);
    setTabOrder(ui.blogStartLabel,ui.blogUrl);
    setTabOrder(ui.blogUrl, ui.username);
    setTabOrder(ui.username, ui.password);
    setTabOrder(ui.password, ui.recentPosts);
    setTabOrder(ui.recentPosts, ui.resizePhotos);
    setTabOrder(ui.resizePhotos, ui.resizeLabel);

    ui.blogUrl->SetExplanation("Blog URL");
    ui.username->SetExplanation("Username");
    ui.password->SetExplanation("Password");
    ui.password->SetPasswordMasking(true);

    QAction* lsk = new QAction(tr("&Save"), this);
    QAction* cancelAction = new QAction(tr("Cancel"),this);

    connect(lsk, SIGNAL(triggered()), this, SLOT(Save()));
    connect(cancelAction,SIGNAL(triggered()),this,SLOT(Cancel()));

    ui.scrollArea->DisableScrollAtWidget(ui.recentPosts->view());
    
    //
    // Finally add the data for WPCustomViewBasicData
    iTitleText = tr("Wordpress");
    iTabText = tr("Edit Blog");
    iHappyAction = lsk;
    iSadAction = cancelAction;
}

SetupBlog::~SetupBlog()
{

}

void SetupBlog::NewBlog()
{
    SetCancel();
    iEditingBlog = false;
    iEditedBlog = NULL;

    ui.blogUrl->setText(QString());
    ui.blogUrl->setReadOnly(false);
    ui.username->setText(QString());
    ui.password->setText(QString());
    ui.recentPosts->setCurrentIndex(0);
    ui.resizePhotos->setChecked(true);
}

void SetupBlog::EditBlog(WPDataBlog* aBlog)
{
    const WPNetworkEndpoint &endpoint = aBlog->iEndpoint;

    SetCancel();

    iEditingBlog = true;
    iEditedBlog = aBlog;

    ui.blogUrl->setText(endpoint.iBlogUrl);
    ui.blogUrl->setReadOnly(true);

    ui.username->setText(endpoint.iUsername);
    ui.password->setText(endpoint.iPassword);

    ui.recentPosts->setCurrentIndex((endpoint.iNumberOfPosts.toInt() / 10 - 1));
    ui.resizePhotos->setChecked(endpoint.iResizePhotos);
}

void SetupBlog::Save()
{
    // Let's first check whether the user supplied URL string is valid.
    QUrl url = QUrl::fromUserInput(ui.blogUrl->text());
    if (url == QUrl())
    {
        QMessageBox::warning(this, tr("Invalid blog URL."), tr("Invalid blog URL."), QMessageBox::Close, QMessageBox::Close);
        return;
    }

    // build WPNetworkEndpoint for new blog settings
    WPNetworkEndpoint settings;

    if (iEditedBlog)
        // initialize to current values; for e.g. API key
        settings = iEditedBlog->iEndpoint;

    settings.iBlogUrl = ui.blogUrl->text();     // must be the same for edited blog
    settings.iUsername = ui.username->text();
    settings.iPassword = ui.password->text();
    settings.iNumberOfPosts = QString::number((ui.recentPosts->currentIndex() + 1) * 10);
    settings.iResizePhotos = ui.resizePhotos->isChecked();

    // TODO what happens if a new blog is added?
    // Should Save/cancel softkeys be disabled, perhaps replaced by "Exit"?
    if (iEditingBlog)
    {
        // save new settings for old blog
        iBlogView->SaveBlogSetup(iEditedBlog, settings);

        // XXX: ???
        iEditedBlog->iStats.iLastUpdated = QDate();

        // return to main blogs view
        iBlogView->ShowBlogsView();

#ifdef Q_WS_MAEMO_5
        close();
#endif
    }
    else
    {
        // apply settings for new blog
        iBlogView->SaveBlogSetup(NULL, settings);

        // stick around in this view until the blog setup finishes in case we get errors
    }

}

void SetupBlog::SetCancel()
{
    if(iCancelSet)
        return;
    // Make sure the negative soft key is Cancel, not Exit.
    // Exit is no more required option when this function is called.
#ifdef Q_OS_SYMBIAN
    QAction* rightSoftKey = new QAction(tr("Cancel"), this);
    connect(rightSoftKey, SIGNAL(triggered()), this, SLOT(Cancel()));
    rightSoftKey->setSoftKeyRole(QAction::NegativeSoftKey);
    addAction(rightSoftKey);
#else

#ifndef Q_WS_MAEMO_5
    QPushButton * cancelButton = new QPushButton(tr("&Cancel"));
    ui.verticalLayout->addWidget(cancelButton);
    connect(cancelButton, SIGNAL(clicked()), this, SLOT(Cancel()));

#endif
#endif
    iCancelSet = true;

}

void SetupBlog::Cancel()
{
    if(ui.blogUrl->text().length())
    {
        WP_CONFIRM_AND_RETURN_ON_FALSE;
    }

    iBlogView->ShowBlogsView();
}

void SetupBlog::SetLogoVisibility()
{
    QSize window = QApplication::desktop()->screenGeometry().size();
    if (window.height() < 640)
    {
        iSvg->hide();
    }
    else
    {
        iSvg->show();
    }
}

void SetupBlog::resizeEvent(QResizeEvent *e)
{
    //SetLogoVisibility();
    QFrame::resizeEvent(e);
}

void SetupBlog::setFocus()
{
    ui.scrollArea->ScrollToTop();
    ui.scrollArea->setFocus();
    //SetLogoVisibility();

    if (!iEditingBlog)
    {
        // Default title (set in BlogView) is "Edit blog", so let's change that
        // XXX: this is the wroooooong place and the wrong way to do this
        iBlogView->setWindowTitle("Add new blog");
    }
}
