/****************************************************************************
**
** Trolltech hereby grants a license to use the Qt/Eclipse Integration
** plug-in (the software contained herein), in binary form, solely for the
** purpose of creating code to be used with Trolltech's Qt software.
**
** Qt Designer is licensed under the terms of the GNU General Public
** License versions 2.0 and 3.0 ("GPL License"). Trolltech offers users the
** right to use certain no GPL licensed software under the terms of its GPL
** Exception version 1.2 (http://trolltech.com/products/qt/gplexception).
**
** THIS SOFTWARE IS PROVIDED BY TROLLTECH AND ITS CONTRIBUTORS (IF ANY) "AS
** IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
** TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
** PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
** OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
** EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
** PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
** LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** Since we now have the GPL exception I think that the "special exception
** is no longer needed. The license text proposed above (other than the
** special exception portion of it) is the BSD license and we have added
** the BSD license as a permissible license under the exception.
**
****************************************************************************/

#include <QApplication>

#include "BlogView.h"
#include "wpmsghandler.h"
#include "utils.h"
#include "SplashScreen.h"

#ifdef Q_OS_SYMBIAN
#include <CoeMain.h>
#include "sym_iap_util.h"
static bool NeedsIAPHack();
#endif //  Q_OS_SYMBIAN

/* Debug stuff here
 * Platform etc. defines are in Qt includes, so they need to be first...
 */

//#define SYMBIAN_QSS_DEBUG_FILE "C:/Data/wp_debug.qss"

#if defined(Q_OS_SYMBIAN) && !defined(__WINSCW__)
//#define SYMBIAN_DEBUG_FILE "C:\\Data\\wplog.txt"
#endif

/* End of debug stuff */

void selectAndLoadStylesheet();
void loadStyleSheet(const QString &sheetName);
void loadStyleSheet(QFile &file);

#ifdef Q_OS_SYMBIAN
void setupSymbianStuff(QApplication & application)
{
#ifdef SYMBIAN_DEBUG_FILE
    WPMsgHandler handler(SYMBIAN_DEBUG_FILE);
    handler.hideMsgType(QtWarningMsg);
    qInstallMsgHandler(WPMsgHandler::handler);
#endif // SYMBIAN_DEBUG_FILE
    
    application.setNavigationMode(Qt::NavigationModeKeypadDirectional);

    if (NeedsIAPHack())
        qt_SetDefaultIap();
}
#endif // !Q_OS_SYMBIAN

#ifdef Q_WS_MAEMO_5
void setupMaemoStuff (QApplication & app)
{
    // override to show QAction icons in menus
    app.setAttribute(Qt::AA_DontShowIconsInMenus, false);
}
#endif

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    QApplication::setAttribute(Qt::AA_S60DontConstructApplicationPanes);

#if defined(Q_OS_SYMBIAN)
    setupSymbianStuff(a);

#elif defined(Q_WS_MAEMO_5)
    setupMaemoStuff(a);

#endif // !Q_OS_SYMBIAN
    
    selectAndLoadStylesheet();

    // show splash
    SplashScreen splash;
    splash.showFullScreen();
    a.processEvents();
    
    // run view
    BlogView view;
    view.showFullScreen();
    splash.hide();
    
    return a.exec();
}


void selectAndLoadStylesheet()
{    
#ifdef Q_OS_SYMBIAN
    #ifdef SYMBIAN_QSS_DEBUG_FILE
        QFile file(SYMBIAN_QSS_DEBUG_FILE);
        loadStyleSheet(file);
    #else  // SYMBIAN_QSS_DEBUG
        if(Utils::smallScreen())
            {
            loadStyleSheet("symbian_3");
            }
        else
            {
            loadStyleSheet("symbian");
            }
    #endif // !SYMBIAN_QSS_DEBUG

#else  // Q_OS_SYMBIAN
    loadStyleSheet("maemo");

#endif // !Q_OS_SYMBIAN
    
    // common styles
    loadStyleSheet("common");
}

void loadStyleSheet(const QString &sheetName)
{
    QFile file(":/qss/" + sheetName.toLower() + ".qss");
    loadStyleSheet(file);
}

void loadStyleSheet (QFile &file)
{
    if (!file.open(QFile::ReadOnly)) {
        qDebug() << "WP::unable to load style sheet";
        return;
    }

    // merge with previous
    QString styleSheet = QLatin1String(file.readAll()) + qApp->styleSheet();
    qApp->setStyleSheet(styleSheet);
}

#ifdef Q_OS_SYMBIAN
bool NeedsIAPHack()
{
    if (!CCoeEnv::Static())
        return false;
    TFindFile fileFinder(CCoeEnv::Static()->FsSession());
    CDir* result = NULL;
    _LIT(KS60ProductIDFile, "Series60v*.sis");
    _LIT(KROMInstallDir, "z:\\system\\install\\");
    if (fileFinder.FindWildByDir(KS60ProductIDFile, KROMInstallDir, result))
        return false;
   
    // Sort the file names so that the newest platforms are first
    if (result->Sort(ESortByName | EDescending) || result->Count() == 0)
    {
        delete result;
        return false;
    }
   
    // Parse the version numbers from the file name (for example, Series60v3.1.sis)
    const int major = (*result)[0].iName[9] - '0';
    const int minor = (*result)[0].iName[11] - '0';
    delete result;
    return (major == 3 && minor == 1);
}
#endif
