/*
 * lineplot.h
 *
 *  Created on: 22.3.2010
 *      Author: aahv
 */

#ifndef LINEPLOT_H
#define LINEPLOT_H

#include "lineplotdata.h"

#include <QWidget>

class LinePlot : public QWidget
{
public:
    LinePlot(QWidget* parent=0);

    void setData(LinePlotData* data);

    void setXAxisMajorTickFrequency(int freq);

protected:
    void resizeEvent(QResizeEvent* event);
    void paintEvent(QPaintEvent* event);

    void drawAxis(QPainter& painter) const;
    void drawData(QPainter& painter) const;

    void calculateGeometry();
    
private:
    int xCoordinateForTick(int index) const;
    int yCoordinateForTick(int index) const;
    int yCoordinateForValue(int index) const;
    int yValueForTick(int index) const;
    
    int yAxisMinValue() const { return zeroVisible ? 0 : data->getMinValue(); }
    int yAxisValueDiff() const
        { return qMax((yAxisTickCount - 1), data->getMaxValue() - yAxisMinValue()); }

private:
    LinePlotData* data;

    QFont font;
    QRect yAxisLabelMetrics;
    QRect xAxisLabelMetrics;

    QPoint origo;
    QPoint xAxisEnd;
    QPoint yAxisEnd;

    int xAxisMajorTickFreq;
    int yAxisTickCount;

    bool zeroVisible;
    bool gridVisible;

};

#endif // LINEPLOT_H
