#ifndef GRAPHICSLAYOUTITERATOR_H_
#define GRAPHICSLAYOUTITERATOR_H_

class QGraphicsLayout;
class QGraphicsLayoutItem;
class QGraphicsItem;

/**
 * An iterator for graphicslayouts.
 * Iterates recursively through QGraphicsLayouts,
 * descending into child layouts.
 * Supports custom focusing model (i.e. can skip certain items)
 * defined via the FocusFunctor class.
 */
class GraphicsLayoutIterator {
public:
    class FocusFunctor {
    public:
        // Returs true if item is focusable, otherwise it will be skipped when iterating
        virtual bool operator()(QGraphicsLayoutItem * /*item*/) { return true; }
    };
    
public:
    GraphicsLayoutIterator(QGraphicsLayoutItem * item, FocusFunctor & isFocusable)
      : item(item), isFocusable(isFocusable) {}
    
    GraphicsLayoutIterator operator=(QGraphicsLayoutItem * newItem) { item = newItem; return *this; }
    
    bool operator++();
    bool operator--();
    
    operator bool();
    operator QGraphicsLayoutItem * () { return item; }
    operator QGraphicsItem * ();
    QGraphicsItem & operator*();
    QGraphicsItem * operator->();
    
private:
    QGraphicsLayout * getParentLayoutAndIndex(QGraphicsLayoutItem * item, int & index);
    int indexOfItemInLayout(QGraphicsLayout & layout);
    QGraphicsLayout * hasChildren(QGraphicsLayoutItem * item);
    
    QGraphicsLayoutItem * item;
    FocusFunctor & isFocusable;
};

#endif /* GRAPHICSLAYOUTITERATOR_H_ */
