/*
 * ExplanatoryLineEdit.cpp
 *
 *  Created on: 11.1.2010
 *      Author: apoi
 */

#include "explanatorylineedit.h"

#include <iostream>

ExplanatoryLineEdit::ExplanatoryLineEdit(QWidget *aParent, const QString& aExplanation)
    : QLineEdit(aParent), iExplanation(aExplanation), iActiveEchoMode(Normal)
{
    connect(this, SIGNAL(textEdited(const QString&)), this, SLOT(textEdited(const QString&)));
    Update();
}

ExplanatoryLineEdit::~ExplanatoryLineEdit()
{
}

void ExplanatoryLineEdit::SetPasswordMasking(bool aMaskPassword)
{
    iActiveEchoMode = aMaskPassword ? Password : Normal;
    Update();
}

void ExplanatoryLineEdit::setText(QString const & aText)
{
    iValue = aText;
    QLineEdit::setText(aText);
    Update();
}

QString ExplanatoryLineEdit::text() const
{
    return iValue;
}

void ExplanatoryLineEdit::SetExplanation(const QString& aExplanation)
{
    iExplanation = aExplanation;
    Update();
}

void ExplanatoryLineEdit::focusInEvent(QFocusEvent *e)
{
    QLineEdit::focusInEvent(e);
    Update();
}

void ExplanatoryLineEdit::focusOutEvent(QFocusEvent *e)
{
    QLineEdit::focusOutEvent(e);
    Update();
}

void ExplanatoryLineEdit::inputMethodEvent (QInputMethodEvent *e)
{
    // Required for maemo on-screen keyboard; we lose focus while it is displayed
    if(iValue.isEmpty()) {
        QLineEdit::setText(iValue);
    }
    QLineEdit::inputMethodEvent(e);
}


void ExplanatoryLineEdit::hideEvent(QHideEvent *)
{
    // Maemo workaround
    clearFocus();
}

void ExplanatoryLineEdit::textEdited(const QString& aText)
{
    iValue = aText;
}

void ExplanatoryLineEdit::Clear()
{
    QLineEdit::clear();
    iValue.clear();
}

void ExplanatoryLineEdit::Update()
{
    if(hasFocus()) {
        setEchoMode(iActiveEchoMode);
        QLineEdit::setText(iValue);
    } else if(iValue.isEmpty()) {
        setEchoMode(Normal);
        QLineEdit::setText(iExplanation);
    } else {
        setEchoMode(iActiveEchoMode);
        // Keep current text
    }
}
