/*
 * ClippingLabel.cpp
 *
 *  Created on: 14.12.2009
 *      Author: apoi
 */

#include "clippinglabel.h"

static const int KClippingLabelMargin = 5;

ClippingLabel::ClippingLabel(QWidget *aParent)
    : WPLabel(aParent)
    , iElideMode(Qt::ElideRight)
{
}

ClippingLabel::~ClippingLabel()
{
}

void ClippingLabel::setText(const QString& aText)
{
    iFullValue = aText;

    int labelWidth = width() - KClippingLabelMargin - indent();
    if (labelWidth == 0)
        return;

    QLabel::setText(fontMetrics().elidedText(aText, iElideMode, labelWidth));
}

void ClippingLabel::resizeEvent(QResizeEvent* e)
{
    setText(iFullValue);
    QLabel::resizeEvent(e);
}
