/*
 * busyindicator.cpp
 *
 *  Created on: 30.4.2010
 *      Author: jlep
 */

#include "busyindicator.h"
#include "utils.h"

#include <QTimer>
#include <QPainter>

BusyIndicator::BusyIndicator(QObject *parent) :
        QObject(parent), iActive(false)
{
    iTimer = new QTimer(this);
    connect(iTimer, SIGNAL(timeout()), this, SLOT(tick()));

    // load animation frames
    iSprites.append(QPixmap(":/images/spinner1.png"));
    iSprites.append(QPixmap(":/images/spinner2.png"));
    iSprites.append(QPixmap(":/images/spinner3.png"));
    iSprites.append(QPixmap(":/images/spinner4.png"));
    iSprites.append(QPixmap(":/images/spinner5.png"));
    iSprites.append(QPixmap(":/images/spinner6.png"));
    iSprites.append(QPixmap(":/images/spinner7.png"));
    iSprites.append(QPixmap(":/images/spinner8.png"));
    
    if(Utils::smallScreen())
        {
        for(QList<QPixmap>::iterator it = iSprites.begin(); it != iSprites.end(); ++it)
            {
            *it = it->scaledToHeight(19);
            }
        }
    

    // assume same size for all pictures
    if (iSprites.count() > 0) {
        iPictureWidth = iSprites[0].size().width();
    }

    iIndex = 0; 
}

BusyIndicator::~BusyIndicator()
{
}

void BusyIndicator::Activate()
{
    if (!iTimer->isActive())
    {
        iActive = true;
        iTimer->start(300);
    
        emit changed();
    }
}

void BusyIndicator::Deactivate()
{
    iActive = false;
    iTimer->stop();
    
    emit changed();
}

void BusyIndicator::tick ()
{
    if (++iIndex == iSprites.count())
        iIndex = 0;

    emit changed();
}

QPixmap& BusyIndicator::PixmapToDraw()
{
    return iSprites[iIndex];
}

