#include "apikeydialog.h"

#include <QMessageBox>

ApiKeyDialog::ApiKeyDialog(QWidget *parent) :
        InputDialog(tr("API key"),
                tr("Blog Administrator API key (in your wordpress.com dashboard profile, 12 characters long)"),
                tr("API key"), parent)
{
}

bool ApiKeyDialog::validateText(QString & text) {
    text = text.trimmed();
    if(text.length() != 12) {
        QMessageBox::warning(this, tr("Invalid API key"), tr("Invalid API key. It must be 12 characters long."), QMessageBox::Close, QMessageBox::Close);
        return false;
    }
    return true;
}
