#ifndef WPMEDIAFILE_H_
#define WPMEDIAFILE_H_

#include <QString>
#include <QStringList>
#include <QMap>

class WPMediaFile
{
public:
    /** Type */
    enum Type {
        /** Not a known media file */
        MEDIA_TYPE_NONE = 0,
    
        /** JPEG image */
        MEDIA_TYPE_IMAGE,

        /** ??? video clip */
        MEDIA_TYPE_VIDEO,

    };
    
    WPMediaFile (const QString &filename) :
                filename(filename), type(typeFromFilename(filename))
            {}
    
    WPMediaFile (const QString &filename, Type type) :
            filename(filename), type(type)
        {}
    
    QString getHtmlSnippet() const;
    
    QString getMimeType() const;
    
    /** Fill filters with wildcarded extensions e.g. "*.jpg" */
    static void wildcardExtensionFilters(Type type, QStringList &filters);
    
    static Type typeFromFilename(QString const & filename);

public: // public data

    /** Path to local file */
    QString filename;

    /** File type */
    Type type;

    /** Resulting ulr */
    QString resultUrl;

    /** VideoPress code... */
    QString resultVideoPressShortcode;

private:
    
    typedef QMap<Type, QStringList> ExtensionMap;
    static ExtensionMap const & extensions();
    
    typedef QMap<QString, QString> MimeMap;
    static MimeMap const & mimeTypes();
    
};

#endif /* WPMEDIAFILE_H_ */
