/*
 * SinglePostView.cpp
 *
 *  Created on: 14.12.2009
 *      Author: apoi
 */

#include <QList>
#include <QVBoxLayout>
#include <QAction>
#include <QString>
#include <QDesktopWidget>
#include <QKeyEvent>

#include "AddComment.h"
#include "BlogView.h"
#include "SinglePostData.h"
#include "SinglePostView.h"
#include "WPData.h"
#include "wpcommentlist.h"
#include "wpscrollarea.h"
#include "WPNetworkEngine.h"
#include "WPData.h"
#include "wpconfirmdialog.h"

SinglePostView::SinglePostView (BlogView& aParent) : MDragWidget(&aParent), iParent(aParent)
{
    setWindowTitle(tr("View Post"));
    iListbox = NULL;
    QVBoxLayout* layout = new QVBoxLayout(this);

    iScrollArea = new WPScrollArea(this);
    layout->setSpacing(0);
    layout->setContentsMargins(0, 0, 0, 0);
    layout->addWidget(iScrollArea);
    iScrollArea->setWidgetResizable(true);
    iScrollArea->setFocusPolicy(Qt::NoFocus);
    
    // XXX labels can stretch the view if they contain long words,
    // so we just use a scrollbar for now...
    iScrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAsNeeded);

    // Prepare softkeys
    //
    QAction* rightSoftKey = new QAction(tr("Back"), this);
    connect(rightSoftKey, SIGNAL(triggered()), this, SLOT(CloseView()));
    rightSoftKey->setSoftKeyRole(QAction::NegativeSoftKey);

    // Finally add the data for WPCustomViewBasicData
    //
    iTitleText = tr("Single post view");
    iTabText = tr("Post");
    iHappyAction = NULL;
    iSadAction = rightSoftKey;
}

SinglePostView::~SinglePostView ()
{

}

void SinglePostView::ShowPost (const WPDataBlog& aBlog, WPPost aPost)
{
    iPost = aPost;

    // forget old list
    // XXX: this is wrong, iScrollArea has ownership of iListbox?
    iListbox->deleteLater();
    iListbox = NULL;
    
	iPostData = new SinglePostData(this, aPost);
	iScrollArea->setWidget(iPostData);

	// add comment
	if (!aPost->IsLocal()) {
        iAddComment = new AddComment(this, aPost, iParent);

        iScrollArea->addWidget(iAddComment);
    }

    // find comments to list
    QList<WPComment> comments = aPost->GetComments();

    // list comments
    // These are deleted when the layout (in iListBox) gets deleted
    iListbox = new WPCommentList(comments, iParent.GetGravatars(), *iScrollArea, iParent.GetThemeData(), true);

    iScrollArea->addWidget(iListbox);
    iScrollArea->AddStretch();

    // signals
    connect(
       &aBlog,  SIGNAL(CommentAdded(WPComment)), 
        iListbox, SLOT(CommentAdded(WPComment))
    );
    connect(
       &aBlog,  SIGNAL(CommentChanged(WPComment)), 
        iListbox, SLOT(CommentChanged(WPComment))
    );
    connect(
       &aBlog,  SIGNAL(CommentRemoved(WPComment)), 
        iListbox, SLOT(CommentRemoved(WPComment))
    );

    iListbox->setFocus();
    ScrollToTop();
}

void SinglePostView::UpdateData (const WPDataBlog& aBlog)
{
    if (iPost) {
        ShowPost(aBlog, iPost);
    }
}

void SinglePostView::ScrollToTop ()
{
    iScrollArea->ScrollToTop();
}

void SinglePostView::CloseView ()
{
    if (iAddComment && iAddComment->HasText())
    {
        WP_CONFIRM_AND_RETURN_ON_FALSE;
    }

    iPost = NULL;
    iParent.ShowTabbedListView();
}

/* XXX: MDragWidget */
bool SinglePostView::MDragWidgetIsDragging () const
{
    return iScrollArea->IsDragging();
}

QSize SinglePostView::VisibleSize () const
{
    return iScrollArea->GetVisibleContentSize();
}

