#include "ShadowGraphicsItem.h"

#include <QLinearGradient>
#include <QPainter>

ShadowGraphicsItem::ShadowGraphicsItem(Side side, QGraphicsItem * parent)
  : QGraphicsWidget(parent)
{
    // XXX
    static const qreal height = 9.0;
    setMinimumHeight(height);
    setMaximumHeight(height);
    
    setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed));
    setSide(side);
}

void ShadowGraphicsItem::setSide(Side side)
{
    QLinearGradient gradient(0.5, 0.0, 0.5, 1.0);
    gradient.setCoordinateMode(QGradient::ObjectBoundingMode);
    
    QColor dark(156, 156, 156);
    QColor mid(205, 205, 205);
    QColor bright(236, 236, 236);
    
    gradient.setColorAt(0.5, mid);
    
    switch(side) {
        case Top:
            gradient.setColorAt(0.0, bright);
            gradient.setColorAt(1.0, dark);
            break;
        case Bottom:
            gradient.setColorAt(0.0, dark);
            gradient.setColorAt(1.0, bright);
            break;
    }
    
    brush = QBrush(gradient);
}

void ShadowGraphicsItem::paint(QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget)
{
    Q_UNUSED(option)
    Q_UNUSED(widget)
    painter->fillRect(boundingRect(), brush);
}
