#ifndef IMAGESELECTIONLIST_H
#define IMAGESELECTIONLIST_H

#include <QStringList>
#include <QThread>
#include <QLinkedList>
#include <QGridLayout>
#include <QTimer>

#include "MDragWidget.h"
#include "WPNetworkEngine.h"
#include "wpcustomviewbasicdata.h"
#include "MediaSearchThread.h"

class QFileInfo;
class WPScrollArea;
class CheckableListItem;
class ImageThumbnailThread;
class ProgressDialog;

class MediaSelectionList : public MDragWidget, public WPCustomViewBasicData
{
    Q_OBJECT

public:
    enum MediaType {
        Images,
        Videos
    };
    
    MediaSelectionList(const QStringList& aInitialSelections, MediaType type, QWidget* aParent = 0);
    ~MediaSelectionList();
    
    bool MDragWidgetIsDragging() const;
    QSize VisibleSize() const;
    void SearchMedia();
    
signals:
    void MediaSelected(QStringList aItems);

    // Wait note related signals
    void TaskStarted(TWPNetworkEngineCommand aCommand);
    void TaskFinished(TWPNetworkEngineCommand aCommand);

    void SearchCanceled();
    void SearchComplete();

public slots:
    void ThreadFinished();
    void ItemsSelected();
    void CancelClicked();
    void setFocus();

    /** Ensure thumbnails for visible items immediately */
    void UpdateThumbnails();

    /** Update thumbnails after 100ms idle timeout */
    void UpdateThumbnailsTimeout ();
    
    void CancelSearch();

private:
    QString FormatFileSize(int aFileSize) const;
    void PopulateLayout();
    void createItem(const QFileInfo& aFileInfo);
    inline bool SearchIsCanceled() { return !iSearchThread || iSearchThread->IsCanceled(); }

private:
    const QStringList iInitialSelections;
    WPScrollArea* iScrollArea;
    
    QList<CheckableListItem*> iItems;
    MediaSearchThread* iSearchThread;
    ImageThumbnailThread* iThumbnailThread;
    
    QWidget iGridWidget;
    QGridLayout iGrid;
    
    ProgressDialog * iProgressDialog;

    QTimer iScrollTimer;
    
    MediaType iMediaType;
};

#endif // IMAGESELECTIONLIST_H
