#ifndef LOCATIONFINDER_H
#define LOCATIONFINDER_H

#if !defined(HAVE_QTM_LOCATION)

struct LocationFinder {};

#else

#include <QObject>
#include <QGeoPositionInfo>
#include <QGeoPositionInfoSource>
#include <QGeoSatelliteInfo>
#include <QGeoSatelliteInfoSource>
#include "WPNetworkEngine.h"

using QtMobility::QGeoPositionInfo;
using QtMobility::QGeoPositionInfoSource;
using QtMobility::QGeoSatelliteInfo;
using QtMobility::QGeoSatelliteInfoSource;

class LocationFinder : public QObject {
    Q_OBJECT

public:
    LocationFinder();
    virtual ~LocationFinder();

    const QGeoPositionInfo& getCurrentPosition() const;
    
    void reset();
    
    void startSearchingForLocation(int timeout = 0);

    void cancelSearch();

    int getSatellitesInView() const;
    int getSatellitesInUse() const;

public slots:
    void positionUpdated(const QGeoPositionInfo &update);
    void fakePositionUpdate();
    void searchTimedOut();
    void satellitesInViewUpdated(const QList<QGeoSatelliteInfo>& satellites);
    void satellitesInUseUpdated(const QList<QGeoSatelliteInfo>& satellites);

signals:
    void searchComplete(const QtMobility::QGeoPositionInfo& info);
    void timeout();
    
    void TaskStarted(TWPNetworkEngineCommand command);
    void TaskFinished(TWPNetworkEngineCommand command);
    void TaskFailed(TWPNetworkEngineCommand command, QString msg);

private:
    static QGeoPositionInfoSource* positionSource;
    QGeoPositionInfo lastPosition;

    static QGeoSatelliteInfoSource* satelliteInfoSource;
    int satellitesInView, satellitesInUse;
    
    bool searchCancelled;

};

#endif // defined(HAVE_QTM_LOCATION)

#endif // LOCATIONFINDER_H
