#ifndef LOCATIONBUTTON_H_
#define LOCATIONBUTTON_H_

#include <QPushButton>
#if defined(HAVE_QTM_LOCATION)
#include <QGeoCoordinate>
#endif // defined(HAVE_QTM_LOCATION)

class QResizeEvent;

class LocationButton : public QPushButton
    {
    Q_OBJECT
    
public:
    LocationButton(QWidget * parent = 0);
    
    void resetCoordinate();
    void setNotSupported();
#if defined(HAVE_QTM_LOCATION)
    void setCoordinate(QtMobility::QGeoCoordinate const & newCoordinate);
#endif // defined(HAVE_QTM_LOCATION)
    
protected:
    // make protected
    void setText(const QString & str) { QPushButton::setText(str); } 
    
    // override
    void resizeEvent(QResizeEvent* event);
    
private:
    void updateText();
    int getTextWidth();
    
private:
    bool supported;
#if defined(HAVE_QTM_LOCATION)
    QtMobility::QGeoCoordinate coordinate;
#endif // defined(HAVE_QTM_LOCATION)
    };

#endif /* LOCATIONBUTTON_H_ */
