#include "LocationButton.h"

#include <QFontMetrics>
#include <QLayout>

#if defined(HAVE_QTM_LOCATION)
using QtMobility::QGeoCoordinate;
#endif // defined(HAVE_QTM_LOCATION)

LocationButton::LocationButton(QWidget * parent)
  : QPushButton(parent)
  , supported(true)
    {
    resetCoordinate();
    }

void LocationButton::resetCoordinate()
    {
    supported = true;
#if defined(HAVE_QTM_LOCATION)
    coordinate = QGeoCoordinate();
#endif // defined(HAVE_QTM_LOCATION)
    updateText();
    }

void LocationButton::setNotSupported()
    {
    supported = false;
    updateText();
    }

#if defined(HAVE_QTM_LOCATION)
void LocationButton::setCoordinate(QtMobility::QGeoCoordinate const & newCoordinate)
    {
    supported = true;
    coordinate = newCoordinate;
    updateText();
    }
#endif // defined(HAVE_QTM_LOCATION)

void LocationButton::resizeEvent(QResizeEvent* event)
    {
    QPushButton::resizeEvent(event);
    updateText();
    }

void LocationButton::updateText()
    {
    if(!supported) {
        setEnabled(false);
        setText(tr("Adding location not supported"));
        return;
    }
    
#if defined(HAVE_QTM_LOCATION)
    setEnabled(true);
    if(!coordinate.isValid()) {
        setText(tr("Add location..."));
        return;
    }
    
    int maxWidth = getTextWidth();
    QFontMetrics fm = fontMetrics();
    QString coordStr = coordinate.toString(QGeoCoordinate::DegreesMinutesSecondsWithHemisphere);
    if(fm.width(coordStr) > maxWidth) {
        coordStr = coordinate.toString(QGeoCoordinate::DegreesMinutesWithHemisphere);
        if(fm.width(coordStr) > maxWidth) {
            coordStr = coordinate.toString(QGeoCoordinate::DegreesWithHemisphere);
        }
    }
    
    /*: %1 is a location coordinate, which has to be on it's own line
     * e.g. 57 18' 22.5" N, 4 27' 32.7" W
     * This REALLY needs to be on it's own line, or the whole view might break!
     */
    setText(tr("Remove location:\n%1").arg(coordStr));
#endif // defined(HAVE_QTM_LOCATION)
    }

int LocationButton::getTextWidth()
    {
    /* XXX how the heck do we really find out the available text width?
     * Worst case scenario is that the text overflows making the 
     */
    
    // assume max one em of padding
    QFontMetrics fm = fontMetrics();
    int em = fm.height();
    return contentsRect().width() - 2 * em;
    }
