#ifndef IMAGETHUMBNAILTHREAD_H
#define IMAGETHUMBNAILTHREAD_H

#include <QMutex>
#include <QWaitCondition>
#include <QPair>
#include <QStringList>
#include <QSize>
#include <QThread>
#include <QImage>
#include <QLinkedList>

class ImageThumbnailThread : public QThread
{
    Q_OBJECT

public:
    ImageThumbnailThread(const QSize& aSize, QObject* parent = 0);
    ~ImageThumbnailThread();

public:
    void run();
    void Cancel();

    void AddImage(QString aFilename, void * requester);

signals:
    void ThumbnailCreated(void * requester, QImage const aImage);

private:
    typedef QPair<QString, void *> FileInfo;
    
    QImage const CreateImage(FileInfo const & info);
    
private:
    const QSize iSize;
    QLinkedList<FileInfo> iImageList;
    volatile bool iThreadCancelled;
    
    QMutex iMutex;
    QWaitCondition iWaitCond;
};

#endif // IMAGESEARCHTHREAD_H
