/*
 * HtmlPainter.h
 *
 *  Created on: 30.7.2010
 *      Author: sber
 */

#ifndef HTMLPAINTER_H_
#define HTMLPAINTER_H_

#include <QString>
#include <QFont>
#include <QTextDocumentFragment>
#include <QFontMetrics>
#include <QTextLayout>

class ThemeData;

class HtmlPainter
    {
public:
    enum Type {
        Content,
        Info
    };
    
    HtmlPainter(Type type, ThemeData const & themeData);
    virtual ~HtmlPainter();
    
    void setContent(QString const & newContent);
    QString const & getContent() { return content; }
    
    QFont getFont() { return font; }
    
    // XXX This is hacky, rendering html content with Qt is a real PITA...
    QString ConvertToDisplayForm(QString const & string);
    
    /* Update draw mode and return new view size */    
    QSize setOneLineMode(int width);
    QSize setLimitedMode(int newWidth, int linesToShow);
    QSize setUnlimitedMode(int width);
    
    typedef QList<QTextLayout::FormatRange> FormatRangeList;
    void SetFormatting(FormatRangeList const & formatting);
    
    void paint(QPainter * painter, QRectF const & rect);
    
    QFontMetrics const fontMetrics() { return QFontMetrics(font); }
    
private:
    
    void DoLayout(QString const & text);
    void paintLimitedLines(QPainter * painter, QRectF const & rect);
    
    ThemeData const & themeData;
    
    int linesToDraw;
    int width;
    QSize previousSize;
    
    QFont font;
    QString content;
    QTextLayout layout;
    };

#endif /* HTMLPAINTER_H_ */
