/*
 * ErrorDialog.h
 *
 *  Created on: 5.1.2010
 *      Author: apoi
 */

#ifndef ERRORDIALOG_H_
#define ERRORDIALOG_H_

#include <QDialog>

#include "ui_ErrorDialog.h"

/**
 * Modal error dialog with a title, text and aknowledgement button.
 *
 * Emits accept() on button press, or reject() on window close.
 */
class ErrorDialog : public QDialog
{
    Q_OBJECT

public:
    ErrorDialog (QWidget *parent);
    ~ErrorDialog ();

public:
    void ShowError (const QString &title, const QString &error);

#ifdef Q_OS_SYMBIAN
protected:
    QSize sizeHint() const;
#endif // Q_OS_SYMBIAN    
    
private:
    void keyPressEvent(QKeyEvent * event);
    
    Ui::ErrorDialog ui;
};

#endif /* ERRORDIALOG_H_ */
