/*
 * ErrorDialog.h
 *
 *  Created on: 5.1.2010
 *      Author: apoi
 */

#include <QSize>
#include <QDesktopWidget>
#include <QKeyEvent>

#include "DialogController.h"
#include "ErrorDialog.h"

ErrorDialog::ErrorDialog(QWidget *parent) : QDialog(parent)
{
    ui.setupUi(this);
    
    // signal from button
    connect(ui.pushButton, SIGNAL(clicked()), this, SLOT(accept()));

// maemo uses click-on-background to dismiss    
#ifdef Q_WS_MAEMO_5
    // modal dialog at bottom of screen
    setWindowFlags(Qt::Dialog);

    // use window's own title
    ui.titleLabel->hide();

    // use background to dismiss
//    ui.pushButton->hide();

#else // XXX: symbian
    // popup in center of screen
    setWindowFlags(Qt::Popup);

#endif
}

ErrorDialog::~ErrorDialog()
{

}
    
void ErrorDialog::ShowError (const QString &title, const QString &error)
{
#ifdef Q_WS_MAEMO_5
    // use dialog frame title
    setWindowTitle(title);
#else        
    ui.titleLabel->setText(title);
#endif

    ui.errorNote->setText(error);
    
    open();

#ifdef Q_OS_SYMBIAN
    // XXX: center popup, does this happen by default?
    QSize parentSize = QApplication::desktop()->screenGeometry().size();
    move((parentSize.width() - width()) / 2, (parentSize.height() - height()) / 2);
#endif
}

#ifdef Q_OS_SYMBIAN

// Fugly hack to get the damn content to fit

QSize ErrorDialog::sizeHint() const
{
    QSize size = ui.verticalLayout->sizeHint();
    QMargins margins = ui.verticalLayout->contentsMargins();
    QSize marginSize(margins.left() + margins.right(), margins.top() + margins.bottom());
    
    QSize extraSize(0, 100); // really don't know why this _has_ to be here...
    
    size += marginSize;
    size += extraSize;
    return size;
}

#endif // Q_OS_SYMBIAN

void ErrorDialog::keyPressEvent(QKeyEvent * event)
{
    if (event->key() == Qt::Key_Select || event->key() == Qt::Key_Context1)
    {
        accept();
        event->accept();
    }
    else
    {
        QDialog::keyPressEvent(event);
    }
}

