#ifndef CATEGORYVIEW_H
#define CATEGORYVIEW_H

#include <QFrame>
#include <QTreeWidget>
#include <QList>
#include <QMap>
#include <QPointer>

#include "wpcustomviewbasicdata.h"
#include "WPData.h"

class CategoryView : public QFrame, public WPCustomViewBasicData
{
    Q_OBJECT

public:
    CategoryView (QWidget *parent = 0);
    ~CategoryView();

private:
    /** Add new WPDataCategory to view, returning the new item */
    QTreeWidgetItem * InsertCategoryItem (const WPDataCategory *category);

public slots:
    /** Rebuild view from given blog's categories */
    void UpdateCategoryData (const WPDataBlog &blog);

    /** Add newly added category to view, and select it */
    void CategoryAdded (WPDataCategory *category);
    
public:
    /** Select the given set of real categories */
    void SelectCategories (const QList<const WPDataCategory *> &categories);

    /** Select the given set of categories by name */
    void SelectCategories (const QStringList &categories);
    
    /** XXX: unused? */
    void setFocus ();

private slots:
    /** Save */
    void SaveClicked ();

    /** Cancel */
    void CancelClicked ();
    
    /** Prompt for new category to add */
    void AddCategoryClicked ();
    
    /** Add category from dialog */
    void AddCategory(QString const & name);

signals:
    /** User selected given set of categories */
    void SelectionDone (const QStringList &categoryNames);

    /** User cancled category selection */
    void SelectionCancelled ();

private:
    /** Main tree view widget for categories */
    QTreeWidget *iTreeWidget;

    /** Mapping of categoryId -> treeItem */
    QMap<QString, QTreeWidgetItem *> iItems;

    /** XXX: the blog we are currently showing categories for, used by SelectCategories() */
    QPointer<WPDataBlog> iCurrentBlog;
};

#endif /* CATEGORYVIEW_H */
