/*
 * BlogSetupView.h
 *
 *  Created on: 17.12.2009
 *      Author: apoi
 */

#ifndef BLOGSETUPVIEW_H_
#define BLOGSETUPVIEW_H_

#include <QGraphicsWidget>
#include <QGraphicsView>
#include <QAction>
#include "WPData.h"
#include "wpcustomviewbasicdata.h"

class BlogView;
class WPScrollArea;
class CollectionList;
class PannableView;
class WPBlogGraphicsList;
class QGraphicsLinearLayout;

class BlogSetupView : public QGraphicsWidget
{
    Q_OBJECT

public:
    BlogSetupView(BlogView* parent, const QGraphicsView& aGraphicsView, PannableView* aPannableView);
    ~BlogSetupView();

    QAction * CloseAction() { return iCloseAction; }
    
public slots:
    void UpdateData(const WPDataUsersBlogs& aUsersBlogs);
    void setFocus();
    
private slots:
	void CloseView();
    
private:
    void resizeEvent(QGraphicsSceneResizeEvent *event);

private:
    BlogView* iParent;
	const QGraphicsView& iGraphicsView;
	WPBlogGraphicsList* iListbox;
	QGraphicsLinearLayout* iLayout;
	PannableView* iPannableView;
	
	QAction * iCloseAction;
};

#endif /* BLOGSETUPVIEW_H_ */
