/*
 * AddComment.cpp
 *
 *  Created on: 16.12.2009
 *      Author: apoi
 */

#include "AddComment.h"
#include "BlogView.h"
#include "SinglePostView.h"

AddComment::AddComment(QWidget* aParent, WPPost aPost, BlogView& aBlogView)
    : QFrame(aParent), iPost(aPost), iBlogView(aBlogView)
{
    ui.setupUi(this);
    ui.commentText->setExplanationText(tr("Tap to begin writing"));

    connect(ui.discardButton, SIGNAL(clicked()), this, SLOT(ClearForm()));
    connect(ui.publishButton, SIGNAL(clicked()), this, SLOT(SaveComment()));

    ClearForm();
}

AddComment::~AddComment()
{
}

bool AddComment::HasText()
{
    return ui.commentText->text().length();
}

void AddComment::SaveComment()
{
    iBlogView.AddNewComment(iPost, ui.commentText->text());
    ClearForm();
}

void AddComment::ClearForm()
{
    ui.commentText->reset();
    ui.commentText->setText(QString());
}
