/*
 * vim:ts=4:sw=4:et:cindent:cino=(0
 */ 

#include <config.h>
#include <glib/gi18n-lib.h>

#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <gtk/gtk.h>
#include <hildon/hildon-note.h>
#include <hildon/hildon-pannable-area.h>
#include <hildon/hildon-defines.h>

#include "tweakr-types.h"
#include "libtweakr-section/tweakr-section.h"
#include "tweakr-module-manager.h"

static gboolean save_ret;

GtkWidget *create_dialog (GtkWindow *parent)
{
    GtkWidget *dialog;

    dialog = gtk_dialog_new_with_buttons
        ("Tweakr",
         parent,
         GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
         GTK_STOCK_SAVE,
         GTK_RESPONSE_OK,
         GTK_STOCK_CANCEL,
         GTK_RESPONSE_CANCEL,
         NULL);

    return dialog;
}

void _save (TweakrSection *section, gboolean *requires_restart)
{
    save_ret &= tweakr_section_save (section, requires_restart);
}

osso_return_t execute (osso_context_t *osso, gpointer data,
                       gboolean user_activated)
{
    GtkWidget *dialog;
    GtkWidget *panarea;
    GtkWidget *box;
    gint response;

    TweakrModuleManager *manager;
    GType *section_types;
    guint n_sections;
    GList *sections = NULL;
    gint i;
    gboolean requires_restart = FALSE;

    manager = g_object_new (TWEAKR_TYPE_MODULE_MANAGER,
                            "module-path", MODULES_DIR,
                            NULL);

    section_types = g_type_children (TWEAKR_TYPE_SECTION, &n_sections);

    dialog = create_dialog (GTK_WINDOW (data));
    panarea = hildon_pannable_area_new ();
    box = gtk_vbox_new (FALSE, HILDON_MARGIN_DOUBLE);

    hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (panarea),
                                            box);
    g_object_set (G_OBJECT (panarea), "height-request", 350, NULL);

    for (i = 0; i < n_sections; i++)
    {
        TweakrSection *section;
        TweakrSectionClass *klass;
        GtkWidget *frame;

        klass = g_type_class_ref (section_types[i]);
        section = tweakr_section_new (section_types[i]);

        sections = g_list_prepend (sections, section);
        frame = gtk_frame_new (section->name);

        gtk_box_pack_start (GTK_BOX (box),
                            frame,
                            FALSE, FALSE, 0);
        gtk_container_add (GTK_CONTAINER (frame),
                           tweakr_section_get_widget (section));

        g_type_class_unref (klass);
    }

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), panarea,
                        TRUE, TRUE, 0);
    gtk_widget_show_all (GTK_DIALOG (dialog)->vbox);

    for (;;)
    {
        save_ret = TRUE;
        response = gtk_dialog_run (GTK_DIALOG (dialog));
        if (response == GTK_RESPONSE_OK)
        {
            /* Save all settings */
            g_list_foreach (sections, (GFunc) _save, &requires_restart);
        }
        if (save_ret)
            break;
    }

    gtk_widget_destroy (GTK_WIDGET (dialog));
    g_object_unref (manager);
    if (sections)
    {
        g_list_foreach (sections, (GFunc) g_object_unref, NULL);
        g_list_free (sections);
    }

    if (requires_restart)
    {
        GtkWidget *note;

        note = hildon_note_new_information
            (GTK_WINDOW (data),
             _("Some of the settings you have changed "
               "will take effect only after you restart your device."));
        gtk_dialog_run (GTK_DIALOG (note));
        gtk_widget_destroy (note);
    }

    return OSSO_OK;
}

