/*
 * vim:ts=4:sw=4:et:cindent:cino=(0
 */ 

#include <config.h>
#include <gtk/gtk.h>

#include "tweakr-section.h"


G_DEFINE_TYPE (TweakrSection, tweakr_section, G_TYPE_OBJECT);


static void
tweakr_section_class_init (TweakrSectionClass *class)
{
}

static void
tweakr_section_init (TweakrSection *section)
{
}

TweakrSection *
tweakr_section_new (GType type)
{
    g_return_val_if_fail (g_type_is_a (type, TWEAKR_TYPE_SECTION),
                          NULL);

    return g_object_new (type, NULL);
}

GtkWidget *
tweakr_section_get_widget (TweakrSection *section)
{
    g_return_val_if_fail (TWEAKR_IS_SECTION (section), NULL);

    return section->widget;
}

gboolean
tweakr_section_save (TweakrSection *section,
                           gboolean *requires_restart)
{
    g_return_val_if_fail (TWEAKR_IS_SECTION (section), TRUE);

    if (TWEAKR_SECTION_GET_CLASS (section)->save)
        return TWEAKR_SECTION_GET_CLASS (section)->save
            (section, requires_restart);
    else
        g_warning ("%s: section class %s doesn't implement "
                   "TweakrSection::filter ()\n",
                   G_STRFUNC, g_type_name (G_TYPE_FROM_INSTANCE (section)));

    return TRUE;
}

