#ifndef SETTINGS_H
#define SETTINGS_H

#include "screenorientation.h"
#include <QSettings>

class Settings : public QSettings
{
    Q_OBJECT

    Q_PROPERTY(QString defaultDownloadDirectory
               READ defaultDownloadDirectory
               WRITE setDefaultDownloadDirectory
               NOTIFY downloadDirectoryChanged)
    Q_PROPERTY(bool useDefaultDownloadDirectory
               READ useDefaultDownloadDirectory
               WRITE setUseDefaultDownloadDirectory
               NOTIFY useDefaultDownloadDirectoryChanged)
    Q_PROPERTY(bool cacheMusicStreams
               READ cacheMusicStreams
               WRITE setCacheMusicStreams
               NOTIFY cacheMusicStreamsChanged)
    Q_PROPERTY(ScreenOrientation::Orientation screenOrientation
               READ screenOrientation
               WRITE setScreenOrientation
               NOTIFY screenOrientationChanged)
    Q_PROPERTY(QString language
               READ language
               WRITE setLanguage
               NOTIFY languageChanged)

public:
    ~Settings();

    static Settings* instance();

    Q_INVOKABLE QVariant setting(const QString &key) const;

    QString defaultDownloadDirectory() const;

    bool useDefaultDownloadDirectory() const;

    bool cacheMusicStreams() const;

    ScreenOrientation::Orientation screenOrientation() const;

    QString language() const;

public slots:
    void setSetting(const QString &key, const QString &value);

    void setDefaultDownloadDirectory(const QString &directory);

    void setUseDefaultDownloadDirectory(bool useDefault);

    void setCacheMusicStreams(bool cache);

    void setScreenOrientation(ScreenOrientation::Orientation orientation);

    void setLanguage(const QString &language);

signals:
    void defaultDownloadDirectoryChanged(const QString &directory);
    void useDefaultDownloadDirectoryChanged(bool useDefault);
    void cacheMusicStreamsChanged(bool cache);
    void screenOrientationChanged(ScreenOrientation::Orientation orientation);
    void languageChanged(const QString &language);

private:
    Settings();

    static Settings *m_instance;
};

#endif // SETTINGS_H
