#ifndef WINDOWSTACK_H
#define WINDOWSTACK_H

#include <QObject>

class StackedWindow;

class WindowStack : public QObject
{
    Q_OBJECT

public:
    ~WindowStack();

    static WindowStack* instance();

    StackedWindow* currentWindow() const;
    StackedWindow* rootWindow() const;
        
public slots:
    void addWindowToStack(StackedWindow *window);
    void removeWindowFromStack(StackedWindow *window);
    void unwindWindowStack();

signals:
    void currentWindowChanged(StackedWindow *window);
    
private:
    WindowStack();

    static WindowStack* m_instance;

    QList<StackedWindow*> m_windowStack;
};

#endif // WINDOWSTACK_H
