#ifndef VALUESELECTORACTION_H
#define VALUESELECTORACTION_H

#include <QWidgetAction>

class SelectionModel;


class ValueSelectorAction : public QWidgetAction
{
    Q_OBJECT

public:
    explicit ValueSelectorAction(QWidget *parent = 0);
    ~ValueSelectorAction();

    SelectionModel* model() const;
    void setModel(SelectionModel *model);

    QVariant value() const;

    QWidget* createWidget(QWidget *parent);

public slots:
    void setValue(const QVariant &value);

signals:
    void valueChanged(const QVariant &value);

protected:
    SelectionModel *m_model;
    QVariant m_value;
};

#endif // VALUESELECTORACTION_H
