#include "songlistdelegate.h"
#include "../shared/songmodel.h"
#include <QPainter>
#include <QMouseEvent>
#include <QMaemo5Style>

SongListDelegate::SongListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void SongListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if (((option.state) & (QStyle::State_Selected)) && (!index.data(SongRoles::ArtworkPressedRole).toBool())) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(64, 64));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

    QImage artwork = index.data(SongRoles::ArtworkRole).value<QImage>();

    if (artwork.isNull()) {
        artwork = QImage("/usr/share/icons/hicolor/64x64/hildon/mediaplayer_default_album.png");
    }

    if (index.data(SongRoles::ArtworkPressedRole).toBool()) {
        painter->setOpacity(0.5);
    }

    painter->drawImage(iconRect, artwork);
    painter->setOpacity(1);

    QRect textRect = option.rect;
    textRect.moveTopLeft(QPoint(textRect.left() + 80, textRect.top() + 8));
    textRect.setHeight(32);
    textRect.setRight(textRect.right() - 8);

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop, index.data(SongRoles::TitleRole).toString());

    textRect.moveTop(textRect.bottom());

    QFont smallFont;
    smallFont.setPixelSize(20);

    painter->setFont(smallFont);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignBottom, index.data(SongRoles::ArtistRole).toString());
    painter->restore();
}

bool SongListDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index) {
    if (event->type() == QEvent::MouseButtonPress) {
        QMouseEvent *mouse = static_cast<QMouseEvent*>(event);

        QRect iconRect = option.rect;
        iconRect.setSize(QSize(64, 64));
        iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

        if (iconRect.contains(mouse->pos())) {
            return model->setData(index, index.row(), SongRoles::ArtworkPressedRole);
        }

        return true;
    }

    if (event->type() == QEvent::MouseButtonRelease) {
        QMouseEvent *mouse = static_cast<QMouseEvent*>(event);

        if (index.data(SongRoles::ArtworkPressedRole).toBool()) {
            QRect iconRect = option.rect;
            iconRect.setSize(QSize(64, 64));
            iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

            if (iconRect.contains(mouse->pos())) {
                emit play(index);
            }
        }
        else if (option.rect.contains(mouse->pos())) {
            emit clicked(index);
        }

        return model->setData(index, -1, SongRoles::ArtworkPressedRole);
    }

    return false;
}

QSize SongListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
