#ifndef SCROLLAREA_H
#define SCROLLAREA_H

#include <QScrollArea>
#include <QKeyEvent>

class QAbstractKineticScroller;

class ScrollArea : public QScrollArea
{
    Q_OBJECT

public:
    explicit ScrollArea(QWidget *parent = 0);

    bool monitorScrolling() const;
    bool isScrolling() const;
    
public slots:
    void positionAtBeginning();
    void positionAtEnd();
    void setMonitorScrolling(bool monitor);

private:
    void keyPressEvent(QKeyEvent *event);

private slots:
    void setScrollRange(int minimum, int maximum);
    void onScrollPositionChanged(int position);

signals:
    void scrollingStarted();
    void scrollingStopped();
    void atEnd();

private:
    QAbstractKineticScroller *m_kineticScroller;
    QTimer *m_scrollTimer;

    int m_minimum;
    int m_maximum;

    bool m_monitor;
};

#endif // SCROLLAREA_H
