#ifndef NOWPLAYINGINFOTAB_H
#define NOWPLAYINGINFOTAB_H

#include "abstracttab.h"
#include "song.h"

using namespace QtUbuntuOne;

class QLabel;
class SeparatorLabel;
class ArtworkLabel;
class ScrollArea;
class ArtworkCache;

class NowPlayingInfoTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit NowPlayingInfoTab(QWidget *parent = 0);

protected:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

    void connectPlaybackSignals();
    void disconnectPlaybackSignals();

private slots:
    void setArtwork();

    void onCurrentSongChanged(Song *song);
    void onScreenLockStateChanged(bool locked);

private:
    QLabel *m_titleLabel;
    QLabel *m_artistLabel;
    QLabel *m_dateLabel;
    QLabel *m_genreLabel;
    QLabel *m_formatLabel;
    QLabel *m_sizeLabel;
    QLabel *m_lengthLabel;

    ArtworkCache *m_cache;

    ArtworkLabel *m_artworkLabel;
    SeparatorLabel *m_propertiesSeparator;

    ScrollArea *m_scrollArea;
};

#endif // NOWPLAYINGINFOTAB_H
