#ifndef ARTISTLISTWINDOW_H
#define ARTISTLISTWINDOW_H

#include "stackedwindow.h"

class ArtistModel;
class ListView;
class QLabel;
class QModelIndex;

class ArtistListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit ArtistListWindow(QWidget *parent = 0);

    void getArtists();

private:
    void showEvent(QShowEvent *event);
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);

    void onItemClicked(const QModelIndex &index);
    
private:
    ArtistModel *m_model;
    ListView *m_view;

    QLabel *m_noResultsLabel;
};

#endif // ARTISTLISTWINDOW_H
