#include "artistlistwindow.h"
#include "albumlistwindow.h"
#include "listview.h"
#include "artistlistdelegate.h"
#include "nowplayingbutton.h"
#include "../shared/artistmodel.h"
#include <QLabel>
#include <QMaemo5Style>

ArtistListWindow::ArtistListWindow(QWidget *parent) :
    StackedWindow(parent),
    m_model(new ArtistModel(this)),
    m_view(new ListView(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No artists found")), this))
{
    this->setWindowTitle(tr("Artists"));
    this->setCentralWidget(m_view);

    m_view->setModel(m_model);
    m_view->setItemDelegate(new ArtistListDelegate(m_view));
    m_view->setMonitorScrolling(true);
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_view, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_view, SIGNAL(scrollingStarted()), NowPlayingButton::instance(), SLOT(hide()));
    this->connect(m_view, SIGNAL(scrollingStopped()), NowPlayingButton::instance(), SLOT(poke()));

    this->onOrientationChanged();
}

void ArtistListWindow::showEvent(QShowEvent *event) {
    this->onLoadingChanged(m_model->loading());
    StackedWindow::showEvent(event);
}

void ArtistListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void ArtistListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void ArtistListWindow::getArtists() {
    m_model->getArtists();
}

void ArtistListWindow::onLoadingChanged(bool loading) {
    this->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void ArtistListWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void ArtistListWindow::onItemClicked(const QModelIndex &index) {
    AlbumListWindow *window = new AlbumListWindow(this);
    window->setWindowTitle(tr("Albums by %1").arg(index.data(ArtistRoles::NameRole).toString()));
    window->show();
    window->getArtistAlbums(index.data(ArtistRoles::IdRole).toString());
}
