#ifndef TRANSFERLISTWINDOW_H
#define TRANSFERLISTWINDOW_H

#include "stackedwindow.h"

class TransferModel;
class ListView;
class QLabel;
class QMenu;

class TransferListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit TransferListWindow(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void showContextMenu(const QPoint &pos);
    void pauseOrResumeTransfer();
    void cancelTransfer();
    void onCountChanged(int count);
    void onScreenLockStateChanged(bool locked);
    
private:
    TransferModel *m_model;
    ListView *m_view;

    QLabel *m_noResultsLabel;

    QMenu *m_contextMenu;
    QAction *m_pauseResumeAction;
    QAction *m_cancelAction;
};

#endif // TRANSFERLISTWINDOW_H
