import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

MySheet {
    id: root

    property string fileName
    property alias isPublic: checkbox.checked

    rejectButtonText: qsTr("Cancel")
    acceptButtonText: !fileName ? "" : qsTr("Done")
    content: Item {
        anchors.fill: parent

        Flickable {
            id: flicker

            anchors.fill: parent
            contentHeight: column.height + UI.PADDING_DOUBLE

            Column {
                id: column

                anchors {
                    left: parent.left
                    right: parent.right
                    top: parent.top
                }
                spacing: UI.PADDING_DOUBLE

                ValueListItem {
                    width: parent.width
                    title: qsTr("File")
                    subTitle: !root.fileName ? qsTr("None chosen") : root.fileName

                    onClicked: {
                        loader.sourceComponent = folderDialog;
                        loader.item.open();
                    }
                }

                MyCheckBox {
                    id: checkbox

                    x: UI.PADDING_DOUBLE
                    width: parent.width - UI.PADDING_DOUBLE * 2
                    text: qsTr("Publish file")
                }
            }
        }

        ScrollDecorator {
            flickableItem: flicker
        }
    }

    Loader {
        id: loader
    }

    Component {
        id: folderDialog

        FolderListDialog {
            showFiles: true
            onAccepted: root.fileName = fileName
        }
    }
}
