import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

ListItem {
    id: root

    Image {
        id: icon

        width: 64
        height: 64
        anchors {
            left: parent.left
            leftMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }
        source: folderModel.isFolder(index) ? "image://theme/icon-m-content-document" + (theme.inverted ? "-inverse" : "")
                                            : "image://theme/" + Utils.iconPathFromFileSuffix(fileName.slice(fileName.lastIndexOf(".") + 1)) + (theme.inverted ? "-inverse" : "")
    }

    Label {
        anchors {
            left: icon.right
            leftMargin: UI.PADDING_DOUBLE
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }
        elide: Text.ElideRight
        font.bold: true
        text: fileName
    }
}
