import urllib
import sys
import os, time, cPickle
from xml.dom import minidom
from tubestatus_gui import *
from conman import *
from PyQt4 import QtGui, QtCore

import conic
import dbus
import gobject
import dbus.glib

TUBESTATUS_URL = 'http://api.tubeupdates.com/?method=get.status&lines=all&format=xml'
CACHE_TIMEOUT = 300

url = TUBESTATUS_URL

class TflStatus(QtGui.QMainWindow):

    tubeStatus_list = {}
    tubeMessages_list = {}

    tubeColour_list = {"Jubilee" : "grey", "Bakerloo" : "brown", "Central" : "red", 
			    "Metropolitan" : "purple", "District" : "green", "Piccadilly" : "darkblue", 
			    "Overground" : "orange", "Victoria" : "lightblue", "DLR": "white", 
			    "Waterloo & City" : "turquoise", "Northern" : "black", "Circle" : "yellow", 
			    "H'smith & City" : "pink" }

    def __init__(self, settingsP, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindowStatus()
        self.ui.setupUi(self)
        #QtCore.QObject.connect(self.ui.pushButtonQuit, QtCore.SIGNAL('clicked()'), QtGui.qApp, QtCore.SLOT('quit()'))
        QtCore.QObject.connect(self.ui.pushButtonQuit, QtCore.SIGNAL('clicked()'), self.doClose)
        self.settings = settingsP

    def doClose(self):
        self.close()

    @QtCore.pyqtSlot()
    def doStuff(self):
        print "it begins!"
        self.showBusyIndicator()
        #self.setup_settings()
        self.load_settings()
        
        labelList = self.ui.centralwidget.findChildren(QtGui.QLabel)
        statusList = self.ui.centralwidget.findChildren(QtGui.QLineEdit)

        self.progress.setLabelText("Checking last update")
        
        if( (time.time() - self.lastUpdate) > CACHE_TIMEOUT ):
    	    counter = 0;
            for names in self.tubeColour_list.keys():
		        labelList[counter].setText(str(names))
		        statusList[counter].setText("Connecting...")
		        labelList[counter].setAutoFillBackground(True)
		        labelList[counter].setPalette(QtGui.QPalette(QtGui.QColor(self.tubeColour_list[names])))
		        counter += 1
            
            self.progress.setLabelText("Checking internet connectivity")
            print "start conn manager"
            self.progress.setLabelText("Connecting to default access point")
            #self.startConnMan()
            openConn = ConnMan()
            openConn.startConnMan()

            self.getStatus()
        else:
            print "use cached values"

        counter = 0
        for names in self.tubeStatus_list.keys():
            self.progress.setLabelText("Updating GUI")
            labelList[counter].setText(str(names))
            statusList[counter].setText(str(self.tubeStatus_list[names]))
            labelList[counter].setAutoFillBackground(True)
            labelList[counter].setPalette(QtGui.QPalette(QtGui.QColor(self.tubeColour_list[names])))
            counter += 1

        self.progress.destroy(True, True)

	counter = 0;
	for names in self.tubeColour_list.keys():
		labelList[counter].setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
		QtCore.QObject.connect(labelList[counter], QtCore.SIGNAL("customContextMenuRequested(const QPoint)"), self.contextMenu)
		if(statusList[counter].text() != "good service"):
			statusList[counter].setAutoFillBackground(True)
			statusList[counter].setPalette(QtGui.QPalette(QtGui.QColor(QtCore.Qt.darkYellow)))
		counter += 1



    def contextMenu(self, pos):
      callerLabel = self.sender()
      try:
        additionalText = self.tubeMessages_list[str(callerLabel.text())]
      except:
        additionalText = "No further info for this line"
      QtGui.QMessageBox.information(self, "Additional Info for " + callerLabel.text() + " Line", additionalText)

    def showBusyIndicator(self):
        self.progress = QtGui.QProgressDialog(self)
        self.progress.setWindowModality(QtCore.Qt.WindowModal)
        self.progress.setAutoReset(True)
        self.progress.setAutoClose(True)
        self.progress.setMinimum(0)
        self.progress.setMaximum(0)
        self.progress.resize(800,100)
        self.progress.setWindowTitle("Hang on....")
        self.progress.setLabelText("Initial setup")
        self.progress.show()




    def load_settings(self):
        # check to see if there is a save file
        self.lastUpdate = 0
              
        try:
            # load the save file into a temp dict
            self.tubeStatus_list = cPickle.loads(str(self.settings.value("tubeStatus_list").toString()))
            self.tubeMessages_list = cPickle.loads(str(self.settings.value("tubeMessages_list").toString()))
	      
            self.lastUpdate = cPickle.loads(str(self.settings.value("Update Time").toString()))
        except:
            print "firstRun... no Savefile found"
	
	
    def getStatus(self):
        if( (time.time() - self.lastUpdate) > CACHE_TIMEOUT ):
            print "refresh cache"

        self.progress.setLabelText("Getting current status")
        response = minidom.parse(urllib.urlopen(url))
        lineNode = response.getElementsByTagName('line')
        for nodes in range(lineNode.length):
            names = lineNode[nodes].getElementsByTagName('name')
            status = lineNode[nodes].getElementsByTagName('status')
            messageNode = lineNode[nodes].getElementsByTagName('messages')

            fullMessage = status[0].firstChild.data.upper()
            for messages in range(messageNode.length):
                message = messageNode[messages].getElementsByTagName('message')
                if(message):
                  fullMessage = fullMessage + "\n" + message[0].firstChild.data

            self.tubeMessages_list[names[0].firstChild.data] = fullMessage
            self.tubeStatus_list[names[0].firstChild.data] = status[0].firstChild.data

        self.progress.setLabelText("Saving refreshed values")

        saveData = cPickle.dumps(self.tubeStatus_list)
        saveMsgData = cPickle.dumps(self.tubeMessages_list)
        currentTime = cPickle.dumps(time.time())

        self.settings.setValue("tubeStatus_list", saveData)
        self.settings.setValue("tubeMessages_list", saveMsgData)
        self.settings.setValue("Update Time", currentTime)

