#
# THe following was all copied pretty much verbatim from http://pymaemo.garage.maemo.org/conic.html
#

import conic
import dbus
import gobject
import dbus.glib


class ConnMan():

    def startConnMan(self):
        self.loop = gobject.MainLoop()
        self.bus = dbus.SystemBus(private=True)
        self.connection = self.connStatus_start()
        self.loop.run()

        if (self.connStatus != "CONNECTED"):
            self.loop = gobject.MainLoop()
            self.bus = dbus.SystemBus(private=True)
            gobject.idle_add(self.connectNew)
            self.loop.run()

    def connStatus_start(self):
	connection = conic.Connection()
	connection.connect("connection-event", self.connStatus_cb)
	connection.set_property("automatic-connection-events", True)
	
	return connection

	
    def connStatus_stop(self, connection, loop):
	connection.set_property("automatic-connection-events", False)
	loop.quit()
	

    def connStatus_cb(self, connection, event):
	print "connection_cb(%s, %s)" % (connection, event)
	
	status = event.get_status()
	error = event.get_error()
	iap_id = event.get_iap_id()
	bearer = event.get_bearer_type()
	
        if status == conic.STATUS_CONNECTED:
	    print "1: (CONNECTED (%s, %s, %i, %i)" % (iap_id, bearer, status, error)
	    self.connStatus = "CONNECTED"
	    self.connStatus_stop(connection, self.loop)
	elif status == conic.STATUS_DISCONNECTED:
	    print "1: (DISCONNECTED (%s, %s, %i, %i)" % (iap_id, bearer, status, error)
	    self.connStatus = "DISCONNECTED"
	    self.loop.quit()
	elif status == conic.STATUS_DISCONNECTING:
	    print "1: (DISCONNECTING (%s, %s, %i, %i)" % (iap_id, bearer, status, error)
	    self.connStatus = "DISCONNECTING"
	    self.loop.quit()
	    
    def connectNew(self):
	magic = 0xAA55

	# Creates the connection object and attach the handler.
	connection = conic.Connection()
	connection.connect("connection-event", self.connStatus_cb, magic)
	
	# The request_connection method should be called to initialize
	# some fields of the instance
	assert(connection.request_connection(conic.CONNECT_FLAG_NONE))

	return False

