//    QtBatteryWidget
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "commonstatic.h"
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
    #include <QLabel>
    #include <QVBoxLayout>
#endif
#include <QDebug>
#include <QHash>
#include <QDesktopServices>
#include <QLabel>
#include <QVBoxLayout>
#include <QProcess>

bool CommonStatic::Debug;
Settings* CommonStatic::CurrentSettings;

QMessageBox::StandardButton CommonStatic::ConfirmMessage(QWidget* parent, QString title, QString message)
{
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Question);
    if (title.isEmpty())
        title = QObject::tr("Confirm");
    msgBox.setWindowTitle(title);
    msgBox.setText(message);
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    return (QMessageBox::StandardButton)msgBox.exec();
}


void CommonStatic::ErrorMessage(QWidget* parent, QString message)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox* box = new QMaemo5InformationBox(parent);
    QObject::connect(box, SIGNAL(clicked()), box, SLOT(accept()));
    box->setTimeout(-1);

    QLabel* text = new QLabel(box);
    text->setMinimumHeight(100);
    text->setText(message);
    text->setAlignment(Qt::AlignCenter);

    box->setWidget(text);
    box->exec();
#else
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Critical);
    msgBox.setText(message);
    msgBox.exec();
#endif
}

void CommonStatic::InfoMessage(QWidget* parent, QString message)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox* box = new QMaemo5InformationBox(parent);
    QObject::connect(box, SIGNAL(clicked()), box, SLOT(accept()));

    QLabel* text = new QLabel(box);
    text->setMinimumHeight(100);
    text->setText(message);
    text->setAlignment(Qt::AlignCenter);

    box->setWidget(text);
    box->exec();
#else
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(message);
    msgBox.exec();
#endif
}

QString CommonStatic::GetHomeFolder()
{
    return QDesktopServices::storageLocation(QDesktopServices::HomeLocation);
}

QString CommonStatic::GetSettingsFolder()
{
    return QString("%1/.qtbatterywidget").arg(CommonStatic::GetHomeFolder());
}

QString CommonStatic::FormatHourMinutes(int seconds)
{
    int hh = seconds / 3600;
    int mm = (seconds - (hh * 3600)) / 60;
    if (hh >= 100)
        return QString("%1:%2").arg(hh, 3, 10, QChar('0')).arg(mm, 2, 10, QChar('0'));
    else
        return QString("%1:%2").arg(hh, 2, 10, QChar('0')).arg(mm, 2, 10, QChar('0'));
}

bool CommonStatic::Bq27x00Present(QObject* parent)
{
    bool res = false;
    QProcess* proc = new QProcess(parent);
    proc->start("lsmod", QIODevice::ReadOnly);
    proc->waitForFinished();
    if (proc->exitCode() == 0){
        QByteArray ba = proc->readAll();
        QString output(ba);
        res = output.contains("bq27x00_battery");
    }else
        qWarning() << "Process returned" << proc->exitCode();
    delete proc;
    return res;
}
