#include "trustdialog.h"
#include "ui_trustdialog.h"
#include <QtGui>

TrustDialog::TrustDialog(QWidget *parent, int initial) :
    QDialog(parent),
    ui(new Ui::TrustDialog)
{
    ui->setupUi(this);
    if(initial != -1) {
        ui->sldScore->setValue(initial);
    }
}

TrustDialog::~TrustDialog()
{
    delete ui;
}

void TrustDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void TrustDialog::on_sldScore_valueChanged(int value)
{
    ui->txtScore->setText(QString::number(value));
    score = value;
}
