#ifndef SEARCHUSERSWINDOW_H
#define SEARCHUSERSWINDOW_H

#include <QMainWindow>
#include <QtNetwork>
#include <QtGui>

namespace Ui {
    class SearchUsersWindow;
}
class Plugin;
class SearchUsersWindow : public QMainWindow {
    Q_OBJECT
public:
    SearchUsersWindow(QWidget *parent, Plugin *plugin);
    ~SearchUsersWindow();
    enum RequestType {AddUser, RemoveUser, SearchUsers};
    RequestType requestType;
protected:
    void changeEvent(QEvent *e);

private:
    Ui::SearchUsersWindow *ui;
    Plugin *plugin;

    QNetworkAccessManager *manager;
    QStandardItemModel *model;
    QHash<QStandardItem*, int> itemToUserId;
    QHash<QStandardItem*, QString> itemToInNetwork;
private slots:
    void on_tblResults_clicked(QModelIndex index);
    void on_txtSearch_returnPressed();
    void on_btnSearch_clicked();
    void replyFinished(QNetworkReply* reply);
};

#endif // SEARCHUSERSWINDOW_H
