#ifndef OPINIONSWINDOW_H
#define OPINIONSWINDOW_H

#include <QMainWindow>
#include <QtNetwork>
#include <QtGui>
#include <QtSvg>


namespace Ui {
    class OpinionsWindow;
}
class Plugin;

class OpinionsWindow : public QMainWindow {
    Q_OBJECT
public:
    OpinionsWindow(QWidget *parent, Plugin *plugin);
    ~OpinionsWindow();

    enum RequestType {GetOpinions, DeleteOpinion};
    RequestType requestType;
    void refreshList();
protected:
    void changeEvent(QEvent *e);

private:
    Ui::OpinionsWindow *ui;
    Plugin *plugin;

    QNetworkAccessManager *manager;
    QStandardItemModel *model;

private slots:
    void on_tblOpinions_clicked(QModelIndex index);
    void replyFinished(QNetworkReply* reply);
};

#endif // OPINIONSWINDOW_H
