#ifndef EDITNETWORK_H
#define EDITNETWORK_H

#include <QMainWindow>
#include <QtNetwork>
#include <QtGui>
namespace Ui {
    class EditNetwork;
}

class Plugin;
class EditNetwork : public QMainWindow {
    Q_OBJECT
public:
    EditNetwork(QWidget *parent, Plugin *plugin);
    ~EditNetwork();

    void refreshNetwork();

    enum RequestType {UpdateTrust, GetNetwork, DeleteTrust};
    RequestType requestType;

protected:
    void changeEvent(QEvent *e);

private:
    Plugin *plugin;

    QNetworkAccessManager *manager;
    Ui::EditNetwork *ui;
    QStandardItemModel *model;
    QHash<QStandardItem*, int> itemToUserId;
    QHash<QStandardItem*, double> itemToTrustScore;
private slots:
    void on_tblNetwork_clicked(QModelIndex index);
    void on_pushButton_clicked();
    void replyFinished(QNetworkReply* reply);
};

#endif // EDITNETWORK_H
