
'''
Advanced Power Monitor Utility Library system
2008-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

from advpowcommon.util.common import *

class system:

  installed_packages = {}

  @staticmethod
  def get_installed_packages(refresh=False):
    if refresh or not system.installed_packages:
      print 'Loading packages list...'
      lines = get_file_lines('/var/lib/dpkg/status')
      packages = {}
      pkey = ''
      installed_ok = False
      for x in lines:
        if x.startswith('Package: '):
          pkey = x.replace('Package: ', '')
          installed_ok = False
        elif x.startswith('Status: ') and x.rfind('ok installed') != -1:
          installed_ok = True
        elif x.startswith('Version: ') and installed_ok:
          packages[pkey] = system.parse_package_version(x.replace('Version: ', ''))
          installed_ok = False
        else:
          continue
      system.installed_packages = packages
    return system.installed_packages

  @staticmethod
  def is_package_installed(package_name):
    if not system.installed_packages:
      system.get_installed_packages()
    return system.installed_packages.has_key(package_name)

  @staticmethod
  def are_packages_installed(packages):
    if not system.installed_packages:
      system.get_installed_packages()
    return set(packages).issubset(set(system.installed_packages.keys()))

  @staticmethod
  def is_package_version_valid(package, version):
    if not system.installed_packages:
      system.get_installed_packages()
    try:
      return cmp(system.installed_packages[package], system.parse_package_version(version)) >= 0
    except:
      return False

  @staticmethod
  def parse_package_version(version):
    split_chars = ('~','-','+')
    version_parts = version.split('.', 2)
    last_parts = [version_parts.pop(-1)]
    for sch in split_chars:
      new_parts = []
      for lp in last_parts:
        new_parts.extend(lp.split(sch))
      last_parts = new_parts
    version_parts.extend(last_parts)
    result = []
    for v in version_parts:
      if v.isdigit():
        result.append(int(v))
      else:
        result.append(v)
    return result

