# -*- coding: utf-8 -*-
'''
Advanced Power UI Gtk Shortcuts
2008-2009(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gtk
from advpowcommon.util.singleton import Singleton

class GtkStockWrapper(Singleton):

  def __init__(self):
    Singleton.__init__(self)
    self.__items = {}

  def __cache(self, stock_item):
    if not(stock_item in self.__items):
      self.__items[stock_item] = gtk.stock_lookup(stock_item)
    return self.__items[stock_item]

  def get_text(self, gtk_stock):
    return str(self.__cache(gtk_stock)[1]).replace('_', '')

__gtk_stock_wrapper = GtkStockWrapper()
def get_gtk_stock_wrapper(): return __gtk_stock_wrapper