
import logging
import os
import sqlite3

class Store:
    _con = None
    def __init__(self, dbFile=None, schemeFile=None):
        self._dbFile = dbFile
        self._schemeFile = schemeFile
        self.initCon()
    def initCon(self):
        db_existed = os.path.isfile(self._dbFile)
        try:
            self._con = sqlite3.connect(self._dbFile)
            self._con.row_factory = sqlite3.Row
        except Exception, e:
            logging.error('Sqlite could not connect to %s: %s', self._dbFile, str(e))
        if (self._schemeFile and not(db_existed)):
            try:
                scheme = file(self._schemeFile)
                cursor = self.cursor()
                if cursor:
                    cursor.executescript(scheme.read())
                    self._con.commit()
            except Exception, e:
                logging.error('Error executing scheme: %s', str(e))
        if self._con:
            self._init_()
    def _init_(self):
        pass
    def cursor(self):
        if self._con:
            return self._con.cursor()
        logging.error('Failed to instance cursor')
        return None
    def commit(self):
        if self._con:
            logging.info('Commiting')
            self._con.commit()
            return True
        return False
    def close(self):
        if self._con:
            logging.info('Closing DB connection')
            self._con.close()
            self._con = None
    def utfLower(self, string):
        return string.decode('utf-8').lower()
    def utfUpper(self, string):
        return string.decode('utf-8').upper()
    def _prepare(self, table, dct):
        assert (table in self._descriptions.keys()), ('Table "%s" not recognized' % table)
        (fields, result) = (self._descriptions[table], {})
        for (k, v) in dct.items():
            if (k not in fields):
                logging.warn('Unrecognized field "%s" for table "%s"', k, table)
            else:
                if (v.__class__ != fields[k]):
                    try:
                        result[k] = fields[k](v)
                    except Exception, e:
                        logging.warn('Failed converting value for field "%s", table "%s"', k, table)
                else:
                    result[k] = v
        return result
    def _sqlInsert(self, table, dct):
        s = 'INSERT INTO %s (%s) VALUES (%s)'
        (fields, values) = (dct.keys(), dct.values())
        return ((s % (table, ', '.join(fields), ', '.join((('?',) * len(fields))))), tuple(values))
    def _sqlUpdate(self, table, dct, where=None, *args):
        s = 'UPDATE %s SET %s%s'
        (fields, values) = (dct.keys(), dct.values())
        return ((s % (table, ', '.join(map(lambda field: ('%s = ?' % field), fields)), ((' WHERE %s' % where) if where else ''))), (tuple(values) + args))
    def _sqlIn(self, field, lst):
        return (('%s IN (%s)' % (field, ', '.join((('?',) * len(lst))))), lst)
    def _sqlSelect(self, table, where=None, *args, **kwargs):
        limit = (kwargs['limit'] if ('limit' in kwargs) else None)
        order = (kwargs['order'] if ('order' in kwargs) else None)
        s = 'SELECT * FROM %s%s%s%s'
        return ((s % (table, ((' WHERE %s' % where) if where else ''), ((' ORDER BY %s' % order) if order else ''), ((' LIMIT %s' % limit) if limit else ''))), args)
    def insert(self, table, **kwargs):
        result = self._prepare(table, kwargs)
        if (len(result) > 0):
            (expr, vals) = self._sqlInsert(table, result)
            cursor = self.cursor()
            logging.debug(('Executing %s %s' % (expr, str(vals))))
            cursor.execute(expr, vals)
            id = cursor.lastrowid
            del cursor
            return id
        return False
    def update(self, table, where=None, *args, **kwargs):
        result = self._prepare(table, kwargs)
        if (len(result) > 0):
            (expr, vals) = self._sqlUpdate(table, result, where, *args)
            cursor = self.cursor()
            logging.debug(('Executing %s %s' % (expr, str(vals))))
            cursor.execute(expr, vals)
            del cursor
            return True
        return False
    def select(self, table, where=None, *args, **kwargs):
        (expr, vals) = self._sqlSelect(table, where, *args, **kwargs)
        cursor = self.cursor()
        logging.debug(('Executing %s %s' % (expr, str(vals))))
        cursor.execute(expr, vals)
        return cursor
    def execute(self, sqlExpr, *args):
        cursor = self.cursor()
        logging.debug(('Executing %s %s' % (sqlExpr, str(args))))
        cursor.execute(sqlExpr, args)
        return cursor
    def getById(self, table, id):
        cursor = self.select(table, 'id = ?', id, limit=1)
        one = cursor.fetchone()
        del cursor
        return one
    def getByUuid(self, table, uuid):
        cursor = self.select(table, 'uuid = ?', uuid, limit=1)
        one = cursor.fetchone()
        del cursor
        return one
    def updateByUuid(self, table, uuid, **kwargs):
        return self.update(table, 'uuid = ?', uuid, **kwargs)
    def updateByUuids(self, table, uuids, **kwargs):
        (where, args) = self._sqlIn('uuid', uuids)
        return self.update(table, where, *args, **kwargs)
    def getValues(self, rows, field):
        return map(lambda row: row[field], rows)
