
import gtk, gobject
from lib.mvc.view import View
from lib.mvc.widgets import *
from lib.util import locality

class AddView(View, ):
    GENERAL_PADDING = (10, 0, 29, 20)
    TOP_HEIGHT = 203
    ENTRY_HEIGHT = 51
    DESCRIPTION_HEIGHT = 102
    BUTTONS_PADDING = (8, 8, 130, 130)
    LEFT_WIDTH = 272
    LEFT_ENTRY_WIDTH = 200
    MIDDLE_PADDING = 20
    def _init_(self):
        self.setWidget(newWindow(title='Add expense'))
        vbox = newVBox()
        self.getWidget().add(vbox)
        fieldBox = newHBox(spacing=self.MIDDLE_PADDING)
        vbox.pack_start(pad(fieldBox, *self.GENERAL_PADDING), expand=True, fill=True)
        leftBox = newVBox(size_request=(self.LEFT_WIDTH, -1))
        rightBox = newVBox()
        fieldBox.pack_start(leftBox, expand=False, fill=True)
        fieldBox.pack_start(rightBox, expand=True, fill=True)
        (avbox, asymbol, aentry) = self._newAmount()
        self.add(asymbol, 'amount_symbol')
        self.add(aentry, 'amount_entry')
        avbox.set_size_request(-1, self.TOP_HEIGHT)
        leftBox.pack_start(avbox, expand=False, fill=True)
        (tvbox, tentry, tlines) = self._newTags()
        self.add(tentry, 'tags_entry')
        self.add(tlines, 'tags_buttons')
        tvbox.set_size_request(-1, self.TOP_HEIGHT)
        rightBox.pack_start(tvbox, expand=False, fill=True)
        (dvbox, dentry) = self._newDate()
        self.add(dentry, 'date_entry')
        leftBox.pack_start(dvbox, expand=True, fill=True)
        (dsvbox, dsentry) = self._newDescription()
        self.add(dsentry, 'description_entry')
        rightBox.pack_start(dsvbox, expand=True, fill=True)
        dbutton = newFingerButton(label='Add')
        self.add(dbutton, 'done_button')
        vbox.pack_start(pad(dbutton, *self.BUTTONS_PADDING), expand=False, fill=True)
    def _newAmount(self):
        vbox = newVBox()
        vbox.pack_start(newLabel(text='Enter price:', alignment=(0.0, 0.5)), expand=False, fill=True)
        hbox = newHBox()
        entry = makeNew(AmountEntry, size_request=(self.LEFT_ENTRY_WIDTH, -1))
        entry.set_input_mode((gtk.HILDON_GTK_INPUT_MODE_NUMERIC | gtk.HILDON_GTK_INPUT_MODE_SPECIAL))
        hbox.pack_start(entry, expand=False, fill=True)
        symbol = newLabel(alignment=(0.0, 0.5))
        hbox.pack_start(symbol, expand=False, fill=True)
        vbox.pack_start(hbox, expand=False, fill=True)
        vbox.pack_start(newLabel(), expand=True, fill=True)
        return (vbox, symbol, entry)
    def _newTags(self):
        vbox = newVBox()
        vbox.pack_start(newLabel(text='Choose tags:', alignment=(0.0, 0.5)), expand=False)
        import gtk
        entry = makeNew(AutocompleteEntry, size_request=(-1, self.ENTRY_HEIGHT))
        entry.set_transform(lambda text: ('%s, ' % text))
        vbox.pack_start(entry, expand=False, fill=False)
        lines = makeNew(ButtonLines)
        vbox.pack_start(pad(lines, top=6), expand=False, fill=False)
        vbox.pack_start(newLabel())
        return (vbox, entry, lines)
    def _newDate(self):
        vbox = newVBox()
        vbox.pack_start(newLabel(text='Select date:', alignment=(0.0, 0.5)), expand=False)
        entry = newEntry(size_request=(self.LEFT_ENTRY_WIDTH, -1))
        hbox = newHBox()
        hbox.pack_start(entry, expand=False)
        hbox.pack_start(newLabel(), expand=True)
        vbox.pack_start(hbox, expand=False)
        vbox.pack_start(newLabel(), expand=True)
        return (vbox, entry)
    def _newDescription(self):
        vbox = newVBox()
        vbox.pack_start(newLabel(text='Add description:', alignment=(0.0, 0.5)), expand=False)
        entry = newTextView(size_request=(-1, self.DESCRIPTION_HEIGHT))
        vbox.pack_start(entry, expand=True, fill=True)
        vbox.pack_start(newLabel(size_request=(-1, 20)), expand=False, fill=False)
        return (vbox, entry)

class ButtonLines(gtk.VBox, ):
    
    LINE_NUM = 2
    MAX_LINE_WIDTH = 470
    BUTTON_HEIGHT = 50
    LINE_PADDING = 3
    BUTTON_PADDING = 6
    def __init__(self):
        gtk.VBox.__init__(self, spacing=self.LINE_PADDING)
        self._items = []
        self._lines = []
        self._callback = None
        self._clear()
    def _clear(self):
        for line in self._lines:
            line.destroy()
        for child in self.get_children():
            self.remove(child)
            child.destroy()
        self._lines = [newHBox(spacing=self.BUTTON_PADDING) for i in range(self.LINE_NUM)]
        for line in self._lines:
            self.pack_start(line, fill=False, expand=False)
    def _render(self):
        (line, rest) = (0, (self._items + []))
        rest.reverse()
        def cal(name, line, rest):
            item = self._itemFactory(name)
            self._lines[line].pack_start(item, expand=False)
            self._lines[line].show_all()
            if (self._lines[line].size_request()[0] > self.MAX_LINE_WIDTH):
                self._lines[line].remove(item)
                line += 1
                if (line < self.LINE_NUM):
                    return cal(name, line, rest)
                else:
                    return
            if (len(rest) > 0):
                return cal(rest.pop(), line, rest)
        if (len(rest) > 0):
            cal(rest.pop(), 0, rest)
    def callBack(self, widget, data=None):
        self._items.remove(data)
        if self._callback:
            self._callback(data)
        self._clear()
        if (len(self._items) > 0):
            self._render()
        self.show_all()
    def _itemFactory(self, name):
        b = newButton(label=('+ ' + name), name='add_tag_button', size_request=(-1, self.BUTTON_HEIGHT))
        b.connect('clicked', self.callBack, name)
        return b
    def feed(self, items):
        self._items = items
        self._clear()
        self._render()
        self.show_all()
    def setCallback(self, callback):
        assert callable(callback), 'Callback must be callable'
        self._callback = callback

class AmountEntry(AutocompleteEntry, ):
    _delimiters_ = ()
    def __init__(self):
        AutocompleteEntry.__init__(self)
        self._amountAllowed = map(str, range(10))
        self._decimal = locality.getDecimalPoint()
    def on_insert_text(self, widget, new_text, new_text_length, position, data=None):
        text = widget.get_text()
        has_decimal = (self._decimal in text)
        def getDecimalPosition(text):
            try:
                i = text.index(self._decimal)
                over = ((len(text) - 1) - i)
                return (i, over)
            except:
                return None
        dpos = getDecimalPosition(text)
        if (dpos != None):
            (dpos, over) = dpos
        else:
            (dpos, over) = (0, 0)
        if (new_text_length == 1):
            pos = widget.get_position()
            if ((dpos >= pos) or (over < 2)):
                if not(has_decimal):
                    if (new_text in self._amountAllowed):
                        AutocompleteEntry.on_insert_text(self, widget, new_text, new_text_length, position, data)
                        if not(self._completed):
                            gobject.idle_add(widget.select_region, (pos + 1), (pos + 1))
                    else:
                        if (new_text == self._decimal):
                            if (len(text) <= (pos + 2)):
                                AutocompleteEntry.on_insert_text(self, widget, new_text, new_text_length, position, data)
                                if not(self._completed):
                                    gobject.idle_add(widget.select_region, (pos + 1), (pos + 1))
                            else:
                                widget.stop_emission('insert-text')
                        else:
                            widget.stop_emission('insert-text')
                            widget.insert_text(self._decimal, pos)
                else:
                    if (new_text in self._amountAllowed):
                        AutocompleteEntry.on_insert_text(self, widget, new_text, new_text_length, position, data)
                    else:
                        widget.stop_emission('insert-text')
            else:
                widget.stop_emission('insert-text')
        else:
            widget.stop_emission('insert-text')
    def set_text_manually(self, text):
        self.handler_block(self._handler)
        self.set_text(text)
        self.handler_unblock(self._handler)
